#include <iostream>
#include <vector>
#include <algorithm>
#include <cmath>
using namespace std;

struct Vektor {
    long long x, y;
    long double ugao;
    int indeks;
};

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int N;
    long long W;
    double e;
    cin >> N >> W >> e;

    vector<Vektor> vektori(N);
    
    for(int i = 0; i < N; i++){
        long long x, y;
        cin >> x >> y;

        long double ugao = atan2l((long double)y, (long double)x);
        vektori[i] = {x, y, ugao, i};
    }

    //sortiranje po uglu
    vector<Vektor> po_uglu = vektori;
    
    sort(po_uglu.begin(), po_uglu.end(), [](const Vektor &a, const Vektor &b){
        return a.ugao > b.ugao;
    });

    long long sumaX1 = 0, sumaY1 = 0;
    vector<int> izabrani_ugao;

    for(auto &v : po_uglu){
        if(sumaX1 + v.x <= W){
            sumaX1 += v.x;
            sumaY1 += v.y;
            izabrani_ugao.push_back(v.indeks);
        }
    }

    //sortiranje po y 
    vector<Vektor> po_Y = vektori;
    sort(po_Y.begin(), po_Y.end(), [](const Vektor &a, const Vektor &b){
        if(a.y != b.y){
            return a.y > b.y; 
        }
        return a.x > b.x;  
    });

    long long sumaX2 = 0, sumaY2 = 0;
    vector<int> izabrani_Y;

    for (auto &v : po_Y) {
        if (sumaX2 + v.x <= W) {
            sumaX2 += v.x;
            sumaY2 += v.y;
            izabrani_Y.push_back(v.indeks);
        }
    }

    if(sumaY1 > sumaY2){
        //cout << "resenje po uglovima:" << '\n';
        //cout << "korisceni vektori: ";
        
        sort(izabrani_ugao.begin(), izabrani_ugao.end());
        
        cout << izabrani_ugao.size() << '\n';
        for(int i = 0; i < izabrani_ugao.size(); i++){
            cout << izabrani_ugao[i] + 1 << " ";
        }
        
        //cout << '\n';
        //cout << "rezultantni vektor: (" << sumaX1 << ", " << sumaY1 << ")";
    }
    else{
        //cout << "resenje po y:" << '\n';
        //cout << "korisceni vektori: ";
        
        sort(izabrani_Y.begin(), izabrani_Y.end());
        
        cout << izabrani_Y.size() << '\n';
        for(int i = 0; i < izabrani_Y.size(); i++){
            cout << izabrani_Y[i] + 1 << " ";
        }
        
        //cout << '\n';
        //cout << "rezultantni vektor: (" << sumaX2 << ", " << sumaY2 << ")\n";
    }
    
    return 0;
}


//limit: 40     greska: 0%
//limit: 35     greska: 2.33%
//limit: 30     greska: 8.11%
//limit: 25     greska: 3.03%
//limit: 20     greska: 18.52%
//limit: 15     greska: 0%
//limit: 10     greska: 0%

//UNAPREDJENA VERZIJA:

//limit: 40     greska: 0%  U + y
//limit: 35     greska: 0%  U
//limit: 30     greska: 0%  U
//limit: 25     greska: 0%  U
//limit: 20     greska: 0%  U
//limit: 15     greska: 0%  U
//limit: 10     greska: 0%  U

//DRUGI TEST PRIMER

//limit: 40     greska: 0%  U + y
//limit: 35     greska: 0%  U + y
//limit: 30     greska: 0%  U + y
//limit: 25     greska: 0%  U
//limit: 20     greska: 0%  U
//limit: 15     greska: 0%  U + y
//limit: 10     greska: 0%  U

//SPECIJALAN PRIMER

//limit: 10     greska: 0%  y